# Minimum Spanning Tree
## Medium
<div class="problems_problem_content__Xm_eO"><p><span style="font-size:18px">Given a weighted, undirected and connected graph of <strong>V</strong> vertices and <strong>E</strong> edges. The task is to find the sum of weights of the edges of the&nbsp;Minimum Spanning Tree.</span></p>

<p>&nbsp;</p>

<p><span style="font-size:18px"><strong>Example 1:</strong></span></p>

<pre><span style="font-size:18px"><strong>Input:
</strong>3 3
0 1 5
1 2 3
0 2 1</span>
<img alt="" src="data:image/png;base64,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">
<span style="font-size:18px"><strong>Output:</strong>
4
<strong>Explanation</strong>:</span>
<img alt="" src="data:image/png;base64,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" style="height:207px; width:288px">
<span style="font-size:18px">The Spanning Tree resulting in a weight
of 4 is shown above.</span>
</pre>

<p><span style="font-size:18px"><strong>Example 2:</strong></span></p>

<pre><span style="font-size:18px"><strong>Input:
</strong>2 1
0 1 5</span>
<img alt="" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAARYAAAC6CAIAAADkhvU5AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAhdEVYdENyZWF0aW9uIFRpbWUAMjAyMTowMTowNiAxOTo1NjoyNJodIawAABVbSURBVHhe7d0JWFTl/gfwF5iVZVgEYgdZBryQCcSuA+hjedVMS8sokeLerHwso80sb38zbVXLrpX+yzDUTOC2CJELPjqKSAQIOsri4Ay7gjbgADPMMPxP8OYtK//oGZlz3vP7PD4Tv98BPAlf3vMeznmP1dDQEAIA3Cxr/F8AwE2BCAFAC0QIAFogQgDQAhECgBaIEAC0QIQAoAUiBAAtECEAaIEIAUALRAgAWiBCANACEQKAFogQALRAhACgBe4X4py+vj6FQqFSqVpbW9Vt6gH9gPaK1qAzCIQCO4mdvcjea1hgYGB4eLhIJMIfBv4CRIgrNBqNXC4/XnG8tbl1MGywa3zXeb/zXV5dBpFBL9EbhUYbvY2oR2TXZydtl/q0+Licc+mt7x3vPz4hISEpKcnOzg5/IvB7ECHyNTQ05BfkK84oLsRdqEmo6QztNPFMeNt12RhsJtVOipXH6qp0sXfGzp0718PDA28Dv4IIkUytVmfvya5rrquaU3VuyjlqqMEbbpC4Vzz34Fy7IruYqJgFCxY4OzvjDQAiRCqDwbAjb8dB+cHKeZX1U+tHOexcn6hPNL9gvviQOG1hWkpKCu5yHkSIQNTgs27TOmWA8tjiY9Q8B3fNJKA5YMaWGYGOgUuXLrW1tcVdDoMIkeZIyZGtOVuPZRxrim/CLXOzMlk9tOsh90r355973tvbG3e5CiJElO352wuOFRzIOtDt241bt4zsqCx0V+gLWS+EhITgFidBhMix9cutRTVFRS8Xmf3g7a9E1ETEfxT/3PLnwsLCcIt74OoEQnya+2mhovD7V74fs/xQTk88ffzp4+vfX69SqXCLeyBCJNgn31d0vGjfin0D9gO4NVbO/O1MZWbluxve1Wg0uMUxECHWO1t/Nnt39sEXD+rtx278+a3KmMrzU8+v37h+cHAQt7gEIsRu/f39b25+U/64vMezB7csoWhukVqsLigowDWXQITY7d3sd2vvqG2b1IZry/nPP//zbdG3LS0tuOYMiBCLVSuqq+urKx+uxLVF9Y7rPTX/1LYvtuGaMyBCbGUymTblbPox7cdBIVNmIBWpFcpLSoVCgWtugAixVaG8sMW+pSWGQQdOQzZDx+cfz9mTg2tugAix0tDQUN7evKoFVbhmjHPx51p6WpRKJa45ACLESqWVpZ12nZ2hnbhmDit0auqp74u/xyUHQIRYace+HYpZDJ1y1CXXlf1Yptdb5pdUYw8ixD4ajeay6nJLFENPH+sl+u7g7pqaGlyTDiLEPkUnilTRKhPfDHfR3SL1UfXFlcW4IB1EiH2OVBxpjmvGBSO1RrYqqrlyahsixDJGo7Fb2d0ZxrwTCb/R69Y7gAa6urpwTTSIEMsoG5VXvK4YRAZcM9XFoIt1jXW4IBpEiGVOKE90hHTggqYLCC1DaCJCMQg9i5BZx4yu8V0/qn/EBdEgQizT2NFonouyqcDEI/QFQinDEfoUoViELuON9GndtS0XOXHJKUSIZS50XLjicQUXdKxGqAmhAwhtQugjhIqHyzV4I329rr0/d/2MC6JBhFimt6uXmqzj4qYNIrQToanDI88I6o0ZCOUgdJOrNV6rf1y/7rIOF0SDCLHMYP+gQUz7XAI1z6dGiERcYXEIXULITOeiDSLDkJ4TK9tAhNhGh4wi2iPFyApzfsOvV/kMv5pp8TmjwIi4cYkPRIhtBtCggPYNQtrh12ue1TCyMunIJtpMApOVwQoXRIMIsY0A2QzY4Ldv2p9+gpHDLjN921M7OcSHAznAQCLE0/Hw2zfNYfj1mrMSI6Vk+JU2np43JIIIAeaxFlvz+/m4uGlBw6/XXGc3UvoPv9LG6+dZizjx3QURYhlbV1u7TtoPnAtAyAOh47jCjiHkjJCZVva1u2QnGCfABdEgQizj5uHm0DFyHEYDNeFZNPzr1Kt3JBxE6BBCGX8xTbpx9hftnd058SQviBDL+Hv4S9rNMV95BaFQhGYitGD4z6zh8ec1vJE++w57n9tGTpMTDiLEMklBSe4N7rigwxGhEwitHL4ujvrzEkKlw00zcW10jQ24eu0DySBCLBMaGCppk/B1tM8oUKjBjBp2Rg7nXjdnfqxMVuOU46JDonFNNIgQy/B4PLsgO7daN1wzkrPaWTBOwJHHSEKE2CcuOs63zBcXjORd4T0hcgIuSAcRYp8H4h/wq/CzNjD3axdQHnB/zP24IB1EiH2cnJwcAhx8Khl6vsux2VHSL5EGSXFNOogQKz1494NhhQx9vKn0gHRK6hQrK05cY0qBCLHS9Kjprr2ubnWMO6kg6BMEnQhaOHUhrjkAIsRK1M/4v9/z94m5E3HNGNIi6YToCY6O5jtBzngQIbZKk6V5aD18yhk0IxL2CCP2Rzx1/1O45gaIEFtZW1s/seiJ6F3RNnozXdZG26T8SUlTklxdXXHNDRAhFpscPjlQGhi5MxLXFuVW6xZaEfrYfY/hmjMgQuy2NmNtUHWQ10kvXFsINRKmbEl5JvMZjlyR8FsQIXYTi8VZS7MStyaa5/Ltm5X8v8nxE+KjIqNwzSUQIdaLlcbOWzgv5Z0UoVaIW2Pr9oLbJ16YuOzRZbjmGIgQCWI8Y0LcQqa+NVWgHesbRYNKgmJ+iFn17Co+3xwXj7MQRIj1mpubN2zYkD47fXL45Olrpwt7xm4sCiwNlO2SrVm5xsXFBbe4x2poiBPLrJCqs7Nz9erVDz/8cEJCAlWuz19/9NjRw1mHu327R97h1rn9h9tj9sasfnm1jw8n7k79KxAhi/nkk0/Kyspw8SuqKRSOdhjRaDRUfmbPnj1t2jTcQujrkq+/zPmyLKOsKd5MC5P+gbXROjU7NbwhfNULq7j2W6A/gghZTFRUVFVVFS5+pdVq7exGtUBPX1/fmjVr4uLi5s6di1u/qlXXrt20tjGgsWJxhV5i5mV5nVXOMz6eEekZueyJZSKRCHc5DCJkGQaDwcHBIT09fevWrbh1IwYGBtatWxccHPzII4/g1u9Rn//9vPfL5eUn551UTlWaeGZ4trGgV5DwbUKgPDBzUWZSUhLuch5EyDJOnjwZGRlJHbYtWbIEt0ZtcHBw/fr1EomE+tjr31NwXn1+456Nrc2tNXNqVFNURuFNrmcvvCKMLI6U/iBNujPpgfkPODk54Q0AImQp27dvz8jIKC8vd3Z2bm5udnFxmThxVJddU1+vjz76SKfTPfvss9bWozqheqbhzLaCba1nWpVxyqaEps7QzlEOSjYDNu5n3eOOxjmcdIiPib/v3vs8PDzwNvAriJBlLF++/IMPPkhOTj5y5MhI584779y9e3dQ0MhavX8pOzu7paXlpZdeutHfw2g0mr3yvccrjmuaNZfCLnWM7+j26+7x6jGIDNR8iRqgeHqesEfI7+dL2iSeTZ7+jf6CeoFvgK8sVkbh4JU7owQRsoyUlBQqPNRciDoYc3R0zM3NXbt2ra+vb01Njb29PX6nP8jLy6uqqnr11VfFYjFu3bi+vj6FQnFWdba+tf5i28VB/aD+it6kM9mIbAQOArFI7OflF+QT5O/vHxERAScM/n9UhMDYO3ToUH5+Pi6GrVnzy4NON2/ejOs/KCoqysrK6u7uxjVgBhiFmEKpVAYHB1MTpM8//xy3fuPYsWN79uz517/+Bb+HYRq4wMditNrfPVBu5PjNZPqTiT518LZr164VK1ZAfhgIImQBFy5csLKyuuZXOuXl5dTrHXfcMVJeVVtbu2XLlueff97Ly8I3BYE/N3I8B8ZYYmIin88vLS0dKTs7O8PDwx0dHal0jXRGqFSqJ5544vTp07gGzANzIctQKBSpqakajWbmzJnUIdz+/ft7enry8vJmz56N32N4sHr99dep2VFMTAxuAeaBCFkMlZAPP/ywrKzMaDROmjTpySeflEr/uwLo5cuXV69ePW/evJSUFNwCjAQRYiKtVkuNPzKZ7LeDEmAmOJ3AOHq9/p133omKioL8sAJEiFmog7oNGzb4+fktXMihNXVZDSLEINRB9ebNm21tbTMzM3ELMB5EiEE+++yzvr6+pUuXcuexCASACDHF7t27m5qasrKyeDwebgE2gAgxQkFBQWVl5Ysvvjj6hRMAQ0CELO/w4cMHDhxYsWLFdW5zAIwFEbKw8vLy3NzclStXcnkpNlaDCFmSQqHYtm0bdfx222234RZgG4iQxTQ2Nn744YfPPPOMv78/bgEWgghZRltb23vvvbdkyZKwMIY+dRiMEkTIArq6ut566620tLTISEY8XQvQAREaaz09PW+++ebMmTMnT56MW4DN4ErtX4wsaqNSqVpbW5vamnR6Xe+VXoPOwBPybCW2YqHY19PX08MzICBgwoQJdBYi7O/vf+ONN6jBZ/78+bgFWI7TEdJoNHK5vLyiXN2stgmzuTD+gspP1e7VfnVpNZsBG1G3iK/jO7U7jW8f79HowT/Ld5I4xUbGUmPIjZ4GMBgMb7/9to+PT0ZGBm4B9uNohBoaGgoKCmrO1OjidCUJJa2hraNfddpZ5Rz7U6zXUS8XkcuM6TOSk5NHsyqiyWTauHGjSCR66qmn4BI4knAuQmq1+qs9X9U119XNqSubUnbTy0xT/M76TSucJjwvvPeee6dPn25j85cPr6f+kbds2ULNgp577rnrvBtgIw5FiDqOysvLOyg/qJynPDr1qFkedkDxVHvO2jPL8aJj5mOZ1EwJd39vx44d586dW7lypUAw1g9yBLcaVyJEDT7vb3r/UsCl3MW5OokOd80nsSIxYntE7B2x6enp1xzXffPNN2VlZatWrYJlqYnEiQiVlJR8nvN5TUZNefwva7XdIiKdKPPTTEmbZPny5e7u7iPN4uJiatL12muvwQNFSEV+hPLz83849kNhVmG7bztu3UoP7X/I8RvHF55/ITAwsLS0dOfOnVR+3Nzc8GZAHMIj9OWXXx6uObzj5R19kj7cuvVmV8323up975x7v/vuO2r+4+vrizcAEpEcodzc3OLq4u0rtuvszT/5ub67Tt/ltcHr0YxHZTIZbgFCEXuBj1wuP3D8QM6KnLHPD2V/xP7eJ3vz8vI0Gg1uAUKRGaH6+vodu3cUvFjQZz92x2/XyI3JNU41bty4cXBwELcAiQiMUH9//783//vk4yfbPcfi/MF1fDz3Y61YW1BQgGtAIgIjlJ2d3XNHT/mkW3j+evTy/5lfWFTY0tKCa0Ac0iKkUCiq66t3PrwT15amHqfWztd+8cUXuAbEISpCJpMpJyfndNppOle+md1XqV+1XGqhso1rQBaiIiSXy6/YXymJKcE1M5hsTPXz6/fs2YNrQBZyIjQ0NLR3796jC47imkmK44s7ejqUSiWuAUHIiVBlZaXOTncq9BSuGcUKdUztKC4uxiUgCDkR2rdvX8OsBlwwz/7k/aU/lur1elwDUhASIY1G06hqPBR1CNfMo5PorIOta2pqcA1IQUiETpw4IYwWDvIZfR1AbVQtdbSJC0AKQiJUUVGhiGP6WePqyOqfqn/CBSAFCREyGo3nlOfKwspwzVS9br0DaKCrqwvXgAgkRKixsdHey14nssAV2TdKH6Sn9hYXgAgkREipVA6GmHsWZEAoFaFNuDKXpvFNarUaF4AIJESoo6ND42nW23KoPC5C6DBC3bhhLh3uHa0XW3EBiEBIhFo9zPd92YTQNIS+wpV5aV21bV1tuABEICFC1ARd7Wamo6NChEIRqkZoHW6YV/+4/p8v/4wLQAQSItTf3/+z2Ezfl9RgthihswjdjxvmZRAZDHpqmgXIQUKEdDpdn8hMN3g/jtAnCHngyuyMAuOgHu4DJwoJERoYGBgUsOP70iQwmQzmWYgYMAQJERIIBDYD7Fjr3UZvYy0g4d8cXEXCl1MkEol1YlwwG0/HsxHBkx2IQkKExGKxY78jLpiN388XiOHhDkQhIUKurq7+nex47rxdp52LqwsuABFIiJCHh4d3hzcumM2hwyHAIwAXgAiERMi53RkXzObe7u7vwY4BE4wSCREKCgriNfBwYS7jEPofhMy9prx3gze1t7gARCAhQoGBgb1tvQKdWafpVIReQygZV2bB1/H5bXxqb3ENiEBChHg8XnBQcHRtNK6Zyq3WzTPIk9pbXAMikBAhSnR0dERZBC6YSlomTY1OxQUgBSERio+PH6wYtDYw93+H2jfvCu/E+ERcA1IQEiEnJ6eggKCEygRcM49PpY9XgBc8tJg8hESIcvfdd0cUMvdYLqow6sG7H8QFIAg5EYqKirLttZXWSXHNJG51bm69btQe4hoQhJwIWVlZzblnjiyXiY8Hjs2NXXjPQmoPcQ0IQk6EKDKZzEXrElXOrB/2PuU+flq/FFkKrgFZiIqQtbV1+qL0qF1RNnqm3FBA7UnirsSli5ZS+4ZbgCykfV3Dw8OjpFH37bwP15YWuzM2WhpN7RWuAXEI/NGYkZHhXu0eftLy37VeJ73CqsOWZSzDNSARgRESi8VPL306fmu8S7sl78yRtEuStyavWLqC2h/cAiQi8wBdKpWmL0yf+85coVaIW2OL+nvveueuzIWZ1J7gFiAUsXNcmUw2I3HGQ289JNCO9Y3W1N84460ZsxNnT5NNwy1ALmIjRFmwYMFd4XelrU0T9ozdWET9XbPWzron/J7FCxbjFiCa1dDQEH6TUPn5+QXHCr7N+vZn31u+Eq9js+P0DdPnTJ6z6P5FuAVIR36EKCUlJZ/lfHYi48TZ+LO4dQv4nfCbnD15yaIlsiQmXiEBbhFORIiiVqvXb1rfEtDy/eLv9RIzP3abOnhL3J4YrAp+5elX/P1haQRu4UqEKAaDIS8vb598X828muqp1SaeGRbmtTZaBx8Kjv46eppsWvr8dD6fjzcAzuBQhEZQw9GuPbtqm2ur5lSdnXLWKDTiDTeIp+cFHA2I/i46xDfkHw/8AwYfzuJchEY0NDR8U/DNqTOnLsVdqkio6AztHOWgRA07bnVu0lKpb5mv9G/StNlpISEheBvgJI5GaIRGo5HL5SUVJW3NbfowffP45ja/th6vHoPIQM2XqAGKGmqoeQ5fx5e0ScY1jfM972tfa+/m65YcnZwqS4VbUAGF0xG6qq+vT6FQqFSq863nm9qa9JQreqPOyBPx+A58kVDk6eUZ6h0aEBAQHh5ua2uLPwwAiBAANJF8dQIAYwAiBAAtECEAaIEIAUALRAgAWiBCANACEQKAFogQALRAhACgBSIEAC0QIQBogQgBQAtECABaIEIA0AIRAoAWiBAAtECEAKAFIgQALRAhAGiBCAFAC0QIAFogQgDQgND/ATKSyZ1YHc9/AAAAAElFTkSuQmCC">
<span style="font-size:18px"><strong>Output:</strong>
5
<strong>Explanation</strong>:
Only one Spanning Tree is possible
which has a weight of 5.</span>
</pre>

<p>&nbsp;</p>

<p><span style="font-size:18px"><strong>Your task:</strong><br>
Since this is a functional problem you don't have to worry about input, you just have to complete the function&nbsp; <strong>spanningTree()</strong> which takes number of vertices V<strong> </strong>and<strong>&nbsp;</strong>an adjacency matrix adj as input parameters&nbsp;and returns an integer denoting the sum of weights of the edges of the Minimum Spanning Tree. Here adj[i] contains a list of lists containing two integers where the first integer a[i][0]&nbsp;denotes that there is an edge between i and a[i][0][0]&nbsp;and second integer a[i][0][1] denotes that the distance between edge i and a[i][0][0]&nbsp;is a[i][0][1].</span></p>

<p><span style="font-size:18px">In other words ,&nbsp;adj[i][j] is of form&nbsp; { u , wt } . So,this denotes that i th node is connected to u th node with&nbsp; edge weight equal to wt.</span></p>

<p>&nbsp;</p>

<p><span style="font-size:18px"><strong>Expected Time Complexity:&nbsp;</strong>O(ElogV).<br>
<strong>Expected Auxiliary Space:&nbsp;</strong>O(V<sup>2</sup>).</span><br>
&nbsp;</p>

<p><span style="font-size:18px"><strong>Constraints:</strong><br>
2 </span> <span style="font-size:18px">≤</span> <span style="font-size:18px"> V</span> <span style="font-size:18px">≤</span> <span style="font-size:18px"> 1000<br>
V-1 </span><span style="font-size:18px">≤</span> <span style="font-size:18px"> E </span> <span style="font-size:18px">≤</span> <span style="font-size:18px"> (V*(V-1))/2<br>
1 </span> <span style="font-size:18px">≤</span> <span style="font-size:18px"> w </span> <span style="font-size:18px">≤</span> <span style="font-size:18px"> 1000<br>
Graph is connected and&nbsp;doesn't contain self loops &amp;&nbsp;multiple edges.</span></p>
</div>